<?php if($webPage == 'apple-login'): ?>
    <div class="tab-content">
        <div class="tab-pane fade show active">
            <form action="<?php echo e(route('admin.configuration.store-third-party-data')); ?>"
                  class="third-party-data-form"
                  method="POST"
                  enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="party_name" value="apple_login">
                <div class="card view-details-container">
                    <div class="card-body p-20">
                        <div class="row align-items-center">
                            <div class="col-xxl-8 col-md-6 mb-md-0 mb-2">
                                <h4 class="black-color mb-1 d-block"><?php echo e(translate('Apple Login')); ?></h4>
                                <p class="fz-12 text-c mb-1"><?php echo e(translate('Use Apple login as your customer Social Media Login turn the switch & setup the required files.')); ?></p>
                                <a href="#0" class="text-decoration-underline text-primary" data-bs-toggle="modal" data-bs-target="#apple-login-get-credential-setup"><?php echo e(translate('Get Credential Setup')); ?></a>
                            </div>
                            <div class="col-xxl-4 col-md-6">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('configuration_manage_status')): ?>
                                    <div class="d-flex flex-sm-nowrap flex-wrap justify-content-end justify-content-end align-items-center gap-sm-3 gap-2">
                                        <div class="mb-0">
                                            <label class="switcher">
                                                <input type="checkbox" name="status" class="switcher_input" <?php if($data['status'] ?? false): echo 'checked'; endif; ?>>
                                                <span class="switcher_control"></span>
                                            </label>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="view-details d-block mt-20" >
                            <div class="discount-type d-flex flex-column gap-sm-4 gap-3 body-bg rounded p-20 mb-20">
                                <div class="">
                                    <label class="mb-2 text-dark d-flex align-items-center gap-1"><?php echo e(translate('Client ID')); ?>

                                        <i class="material-icons fz-14 text-light-gray" data-bs-toggle="tooltip"
                                           data-bs-placement="top"
                                           title="<?php echo e(translate('Enter Client ID')); ?>"
                                        >info</i>
                                    </label>
                                    <input type="text" name="client_id" class="form-control h-46" placeholder="Ex: Client ID" value="<?php echo e($data['client_id'] ?? ''); ?>" />
                                </div>

                                <div class="">
                                    <label class="mb-2 text-dark d-flex align-items-center gap-1"><?php echo e(translate('Enter Team ID')); ?>

                                        <i class="material-icons fz-14 text-light-gray" data-bs-toggle="tooltip"
                                           data-bs-placement="top"
                                           title="<?php echo e(translate('Team ID')); ?>"
                                        >info</i>
                                    </label>
                                    <input type="text" class="form-control h-46" name="team_id" placeholder="Ex: Team ID"
                                           value="<?php echo e($data['team_id'] ?? ''); ?>">
                                </div>

                                <div class="">
                                    <label class="mb-2 text-dark d-flex align-items-center gap-1"><?php echo e(translate('Enter Key ID')); ?>

                                        <i class="material-icons fz-14 text-light-gray" data-bs-toggle="tooltip"
                                           data-bs-placement="top"
                                           title="<?php echo e(translate('Key ID')); ?>"
                                        >info</i>
                                    </label>
                                    <input type="text" class="form-control h-46" name="key_id" placeholder="Ex: Client Key ID"
                                           value="<?php echo e($data['key_id'] ?? ''); ?>">
                                </div>
                                <div class="">
                                    <label class="mb-2 text-dark d-flex align-items-center gap-1"><?php echo e(translate('Service File')); ?>

                                        <i class="material-icons fz-14 text-light-gray" data-bs-toggle="tooltip"
                                           data-bs-placement="top"
                                           title="<?php echo e(translate('upload Service File')); ?>"
                                        >info</i>
                                    </label>
                                    <input type="file" class="form-control h-46" name="apple_service_file" placeholder="Ex: Service File" accept=".json">
                                    <?php if($data['service_file'] ?? false): ?>
                                        <label class="mt-2"> <?php echo e(translate('service_file_already_exists')); ?> </label>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('configuration_update')): ?>
                            <div class="d-flex justify-content-end trans3 mt-4">
                                <div class="d-flex justify-content-sm-end justify-content-center gap-2 gap-sm-3 flex-grow-1 flex-grow-sm-0 bg-white action-btn-wrapper trans3">
                                    <div class="d-flex justify-content-end gap-xl-3 gap-2">
                                        <button type="reset" class="btn btn--secondary rounded"><?php echo e(translate('Reset')); ?></button>
                                        <button type="submit" class="btn btn--primary demo_check rounded">
                                            <?php echo e(translate('Save')); ?>

                                        </button>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="modal fade" id="apple-login-get-credential-setup" tabindex="-1"
         aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content" style="text-align: left;">
                <div class="modal-header border-0 pb-0 d-flex justify-content-end">
                    <button type="button" class="btn-close border-0 btn-circle bg-section2 shadow-none" data-bs-dismiss="modal" aria-label="Close">
                    </button>
                </div>
                <div class="modal-body px-20 py-0 mb-30">
                    <div class="d-flex gap-3 flex-column align-items-center text-center mb-4">
                        <h4 class="modal-title" id="staticBackdropLabel"><?php echo e(translate('Apple API Set up Instructions')); ?></h4>
                    </div>

                    <ol class="d-flex flex-column gap-2">
                        <li><?php echo e(translate('Go to apple developer page')); ?> (<a href="https://developer.apple.com/account/resources/identifiers/list" target="_blank"><?php echo e(translate('Click here')); ?></a>)
                        </li>
                        <li><?php echo e(translate('Here in top left corner you can see the')); ?>

                            <b><?php echo e(translate('Team ID')); ?></b> <?php echo e(translate('[Apple developer account name ]- Team ID')); ?></li>
                        <li><?php echo e(translate('Click plus icon')); ?> -&gt; <?php echo e(translate('Select app IDs')); ?>

                            -&gt; <?php echo e(translate('Click on continue')); ?></li>
                        <li><?php echo e(translate('Put a description and also identifier (identifier that used for app) and this is the')); ?>

                            <b><?php echo e(translate('Client ID')); ?></b></li>
                        <li><?php echo e(translate('Click continue and download the file in device named AuthKey ID.p8 (store it safely and it is used for push notification) ')); ?></li>
                        <li><?php echo e(translate('Again click plus icon')); ?>

                            -&gt; <?php echo e(translate('Select service IDs')); ?> -&gt; <?php echo e(translate('Click on continue')); ?></li>
                        <li><?php echo e(translate('Push a description and also identifier and continue')); ?> </li>
                        <li><?php echo e(translate('Download the file in device named')); ?>

                            <b><?php echo e(translate('AuthKey KeyID.p8')); ?></b>
                            <?php echo e(translate('[This is the service key ID file and also after AuthKey that is the key ID]')); ?>

                        </li>
                    </ol>
                    <div class="d-flex justify-content-center mt-4">
                        <button type="button" class="btn btn-primary px-5" data-bs-dismiss="modal"><?php echo e(translate('Got it')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/azentech/public_html/serviceApp/Modules/BusinessSettingsModule/Resources/views/admin/configurations/third-party/apple-login.blade.php ENDPATH**/ ?>