<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?></title>

    <link rel="shortcut icon" href="<?php echo e(asset('public/assets/installation/assets/img/favicon.svg')); ?>">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="<?php echo e(asset('public/assets/installation/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/installation/assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/installation/assets/css/custom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/admin-module/css/toastr.css')); ?>">


    <style>
        .main-background-image {
            background-image: url('<?php echo e(asset('public/assets/installation/assets/img/page-bg.png')); ?>')
        }
    </style>
</head>

<body>
<section class="w-100 min-vh-100 bg-img position-relative py-5 main-background-image">

    <div class="logo">
        <img src="<?php echo e(asset('public/assets/installation/assets/img/favicon.svg')); ?>" alt="">
    </div>

    <div class="custom-container">
        <?php echo $__env->yieldContent('content'); ?>

        <footer class="footer py-3 mt-4">
            <div class="d-flex flex-column flex-sm-row justify-content-between gap-2 align-items-center">
                <div class="footer-logo">
                    <img src="<?php echo e(asset('public/assets/installation/assets/img/logo.svg')); ?>" alt="<?php echo e(translate('image')); ?>">
                </div>
                <p class="copyright-text mb-0">© <?php echo e(date("Y")); ?> | <?php echo e(translate('All Rights Reserved')); ?></p>
            </div>
        </footer>
    </div>
</section>

<script type="text/javascript">
    "use strict";

    $(".showLoder").on('click', function () {
        $('#loading').fadeIn();
    })
</script>

</body>

<script src="<?php echo e(asset('public/assets/installation/assets/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/admin-module/js/jquery-3.6.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/installation/assets/js/script.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/admin-module/js/toastr.js')); ?>"></script>

<?php echo Toastr::message(); ?>

<script>
    <?php if(isset($errors) && $errors->any()): ?>
    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    toastr.error('<?php echo e($error); ?>', Error, {
        CloseButton: true,
        ProgressBar: true
    });
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</script>

</html>
<?php /**PATH /home/azentech/public_html/serviceApp/resources/views/layouts/blank.blade.php ENDPATH**/ ?>