<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo e(translate('Provider_login')); ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta name="description" content=""/>
    <meta name="keywords" content=""/>
    <meta name="robots" content="nofollow, noindex ">
    <?php ($favIcon = getBusinessSettingsImageFullPath(key: 'business_favicon', settingType: 'business_information', path: 'business/',  defaultPath : 'public/assets/admin-module/img/placeholder.png')); ?>
    <link rel="shortcut icon" href="<?php echo e($favIcon); ?>"/>

    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,400&display=swap"
        rel="stylesheet"/>

    <link href="<?php echo e(asset('public/assets/provider-module')); ?>/css/material-icons.css" rel="stylesheet"/>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/provider-module')); ?>/css/bootstrap.min.css"/>
    <link rel="stylesheet"
          href="<?php echo e(asset('public/assets/provider-module')); ?>/plugins/perfect-scrollbar/perfect-scrollbar.min.css"/>

    <link rel="stylesheet" href="<?php echo e(asset('public/assets/provider-module')); ?>/css/style.css"/>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/provider-module')); ?>/css/toastr.css">
</head>

<body>
<div class="preloader"></div>
<?php
$logo = getBusinessSettingsImageFullPath(key: 'business_logo', settingType: 'business_information', path: 'business/',  defaultPath : 'public/assets/admin-module/img/placeholder.png');

?>
<div>
    <form action="<?php echo e(route('provider.auth.login')); ?>" enctype="multipart/form-data" method="POST" id="login-form">
        <?php echo csrf_field(); ?>
        <div class="login-wrap">
            <div class="login-left d-flex justify-content-center align-items-center bg-center" data-bg-img="<?php echo e(asset('public/assets/provider-module')); ?>/img/media/login-bg.png">
                <div class="tf-box d-flex flex-column gap-3 align-items-center justify-content-center p-5 mx-4 mx-sm-5 h-75">
                    <img class="login-logo mb-2"
                        src="<?php echo e($logo); ?>" alt="<?php echo e(translate('logo')); ?>">
                    <h2 class="text-center text-dark px-xl-5">Your <strong class="c1">Right <br> Choice </strong> for On <br> Demand Business</h2>
                </div>
            </div>
            <div class="login-right-wrap bg-white">
                <div class="login-right w-100 m-auto p-3">

                    <div class="d-flex justify-content-between align-items-start gap-2 mb-5 mt-3">
                        <div class="d-flex flex-column gap-2">
                            <h2 class="c1 fw-medium"><?php echo e(translate('provider_Sign_In')); ?></h2>
                            <p><?php echo e(translate('sign_in_to_stay_connected')); ?></p>
                        </div>
                        <span class="badge badge-primary fz-12 opacity-75">
                            <?php echo e(translate('Software_Version')); ?> : <?php echo e(env('SOFTWARE_VERSION')); ?>

                        </span>
                    </div>

                    <div class="mb-4">
                        <div class="mb-5">
                            <div class="form-floating form-floating__icon">
                                <input type="email" name="email_or_phone" class="form-control" value="<?php echo e(request()->cookie('provider_remember_email')); ?>"
                                        placeholder="<?php echo e(translate('email')); ?>" required="" id="email">
                                <label><?php echo e(translate('email')); ?></label>
                                <span class="material-icons">mail</span>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="form-floating form-floating__icon">
                                <input type="password" name="password" class="form-control" value="<?php echo e(request()->cookie('provider_remember_password')); ?>"
                                        placeholder="<?php echo e(translate('password')); ?>" required=""
                                        id="password">
                                <label><?php echo e(translate('password')); ?></label>
                                <span class="material-icons togglePassword">visibility_off</span>
                                <span class="material-icons">lock</span>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between">
                            <div class="d-flex gap-1 align-items-center">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember_me" value="1" id="rememberMeCheckbox" <?php echo e(request()->cookie('provider_remember_checked') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="rememberMeCheckbox"><?php echo e(translate('Remember me?')); ?></label>
                                </div>
                            </div>
                            <div class="d-flex gap-1 align-items-center">
                                <a href="<?php echo e(route('provider.auth.reset-password.index')); ?>"
                                    class="lh-1"><?php echo e(translate('Forget Password')); ?>?</a>
                            </div>
                        </div>
                    </div>

                    <div class="recaptcha d-flex justify-content-center mb-3 dark-support">
                        <?php ($recaptcha = business_config('recaptcha', 'third_party')); ?>
                        <?php if(isset($recaptcha) && $recaptcha->is_active): ?>
                            <div class="recaptcha d-flex justify-content-center mb-4">
                                <input type="hidden" name="g-recaptcha-response" id="g-recaptcha-response">
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="d-flex mb-4">
                        <button class="btn flex-grow-1 btn--primary text-capitalize"
                                type="submit"><?php echo e(translate('login')); ?></button>
                    </div>

                    <?php if(business_config('provider_self_registration','provider_config')->live_values??0): ?>
                        <div class="text-center fz-12 pb-4">
                            <?php echo e(translate('Want to Join as Provider')); ?> <a
                                href="<?php echo e(route('provider.auth.sign-up')); ?>"
                                class="c1 text-decoration-underline"><?php echo e(translate('Register Here')); ?></a>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if(env('APP_ENV')=='demo'): ?>
                    <div class="login-footer d-flex justify-content-between c1-bg text-light gap-3">

                        <button type="button" class="btn login-copy">
                            <span class="material-symbols-outlined m-0">content_copy</span>
                        </button>
                        <div class="flex-grow-1">
                            <div><?php echo e(translate('email')); ?> : <?php echo e(translate('provider@provider.com')); ?></div>
                            <div><?php echo e(translate('password')); ?> : <?php echo e(translate('12345678')); ?></div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </form>
</div>

<script src="<?php echo e(asset('public/assets/provider-module')); ?>/js/jquery-3.6.0.min.js"></script>
<script src="<?php echo e(asset('public/assets/provider-module')); ?>/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo e(asset('public/assets/provider-module')); ?>/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="<?php echo e(asset('public/assets/provider-module')); ?>/js/main.js"></script>


<script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async defer></script>
<script src="<?php echo e(asset('public/assets/provider-module')); ?>/js/sweet_alert.js"></script>
<script src="<?php echo e(asset('public/assets/provider-module')); ?>/js/toastr.js"></script>
<?php echo Toastr::message(); ?>


<?php ($recaptcha = business_config('recaptcha', 'third_party')); ?>
<?php if(isset($recaptcha) && $recaptcha->is_active): ?>
    <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e($recaptcha->live_values['site_key']); ?>"></script>
    <script>
        "use strict";
        $('#signInBtn').click(function (e) {
            e.preventDefault();

            if (typeof grecaptcha === 'undefined') {
                toastr.error('Invalid recaptcha key provided. Please check the recaptcha configuration.');
                return;
            }

            grecaptcha.ready(function () {
                grecaptcha.execute('<?php echo e($recaptcha->live_values['site_key']); ?>', {action: 'submit'}).then(function (token) {
                    document.getElementById('g-recaptcha-response').value = token;
                    document.querySelector('form').submit();
                });
            });

            window.onerror = function(message) {
                var errorMessage = 'An unexpected error occurred.';
                if (message.includes('Invalid site key')) {
                    errorMessage = 'Invalid site key provided. Please check the site key configuration.';
                } else if (message.includes('not loaded in api.js')) {
                    errorMessage = 'reCAPTCHA API could not be loaded. Please check the API configuration.';
                }
                toastr.error(errorMessage)
                return true;
            };
        });
    </script>
<?php endif; ?>

<script>
    "use strict";

        <?php if(env('APP_ENV')=='demo'): ?>

            $('.login-copy').on('click', function () {
                copy_cred()
            })

            function copy_cred() {
                $('#email').val('provider@provider.com');
                $('#password').val('12345678');
                toastr.success('<?php echo e(translate('Copied successfully')); ?>', 'Success', {
                    CloseButton: true,
                    ProgressBar: true
                });
            }
       <?php endif; ?>

        <?php ($recaptcha = business_config('recaptcha', 'third_party')); ?>
        <?php if(isset($recaptcha) && $recaptcha->is_active): ?>

            var onloadCallback = function () {
                grecaptcha.render('recaptcha_element', {
                    'sitekey': '<?php echo e($recaptcha->live_values['site_key']); ?>'
                });
            };

            $("#login-form").on('submit', function (e) {
                var response = grecaptcha.getResponse();

                if (response.length === 0) {
                    e.preventDefault();
                    toastr.error("<?php echo e(translate('please_check_the_recaptcha')); ?>");
                }
            });
        <?php endif; ?>

        <?php if($errors->any()): ?>

            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            toastr.error('<?php echo e($error); ?>', Error, {
                CloseButton: true,
                ProgressBar: true
            });
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       <?php endif; ?>
</script>
</body>
</html>
<?php /**PATH /home/azentech/public_html/serviceApp/Modules/Auth/Resources/views/provider-login.blade.php ENDPATH**/ ?>