<?php if($webPage == 'sms_config'): ?>
    <div class="tab-content">
        <div class="tab-pane fade show active"
             id="sms_config">
            <div class="pick-map mb-3 p-12 rounded d-flex flex-md-nowrap flex-wrap align-items-center gap-1 bg-primary bg-opacity-10">
                <img src="<?php echo e(asset('public/assets/admin-module/img/icons/focus_mode.svg')); ?>" alt="focus mode icon">
                <p class="fz-12"><?php echo e(translate('This SMS gateway will work for')); ?> <a <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('login_setup_view')): ?> href="<?php echo e(route('admin.business-settings.login.setup')); ?>" <?php endif; ?> class="text-primary fw-semibold text-decoration-underline" target="_blank"> <?php echo e(translate('OTP verification')); ?> </a> <?php echo e(translate('_or')); ?> <a <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('firebase_view')): ?> href="<?php echo e(route('admin.configuration.third-party', 'firebase-authentication')); ?>" <?php endif; ?> target="_blank" class="text-primary fw-semibold text-decoration-underline"><?php echo e(translate('Notification')); ?></a> <?php echo e(translate('_through SMS.')); ?></p>
            </div>
            <div class="bg-warning bg-opacity-10 fs-12 p-12 rounded mb-3">
                <div class="d-flex align-items-center gap-2">
                    <img src="<?php echo e(asset('public/assets/admin-module/img/icons/alert_info.svg')); ?>" alt="alert info icon">
                    <p class="fz-12 fw-normal"><?php echo e(translate('Please recheck if you have put all the data correctly or contact your SMS gateway provider for assistance.')); ?></p>
                </div>
            </div>
            <div class="card mb-20">
                <div class="card-body p-20">
                    <div class="row g-lg-4 g-4 align-items-center">
                        <div class="col-lg-3">
                            <h3 class="mb-2"><?php echo e(translate('SMS Configuration')); ?></h3>
                            <p class="fz-12 mb-xl-3 mb-xxl-4 mb-3"><?php echo e(translate('Choose the SMS model you want to use for OTP & Other SMS')); ?></p>
                            <?php if(!(count(collect($data['gateways'])->where('is_active', 1)) > 0) && $data['firebase_otp_verification']['live_values']['status'] == 0): ?>
                                <div
                                    class="mb-15 bg-danger bg-opacity-10 fs-12 p-10 rounded d-flex gap-2 align-items-center">
                                        <span class="material-symbols-outlined text-danger">
                                                    warning
                                                </span>
                                    <span><?php echo e(translate('3rd_party_is_not_set_up_yet_please_configure_it_first_to_ensure_it_works_properly')); ?>.</span>
                                </div>
                            <?php endif; ?>
                            <?php if($data['firebase_otp_verification']['live_values']['status'] == 1 && empty($data['firebase_otp_verification']['live_values']['web_api_key'])): ?>
                                <div
                                    class="mb-15 bg-danger bg-opacity-10 fs-12 p-10 rounded d-flex gap-2 align-items-center">
                                        <span class="material-symbols-outlined text-danger">
                                                    warning
                                                </span>
                                    <span><?php echo e(translate('Firebase OTP is not set up yet. Please configure it first to ensure it works properly.')); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-9">
                            <div class="bg-light rounded-2 p-20">
                                <div class="d-flex align-items-center justify-content-between gap-2 flex-wrap mb-3">
                                    <label class="text-dark"><?php echo e(translate('Select Business Model')); ?>

                                        <i class="material-icons fz-14 text-light-gray" data-bs-toggle="tooltip"
                                           data-bs-placement="top"
                                           title="<?php echo e(translate('Select a configuration model to ensure proper operation')); ?>"
                                        >info</i>
                                    </label>
                                </div>
                                <div class="bg-white rounded-2 p-16">
                                    <div class="row g-xl-4 g-3">
                                        <div class="col-md-6">
                                            <div class="custom-radio">
                                                <input type="radio"
                                                       id="radio-option-1"
                                                       value="0"
                                                       <?php if($data['firebase_otp_verification']['live_values']['status'] == 0): echo 'checked'; endif; ?>
                                                       class="<?php echo e(env('APP_ENV') == 'demo' ? '' : 'update-status-modal'); ?>"
                                                       data-url="<?php echo e(route('admin.configuration.update-firebase-otp-status')); ?>"
                                                       data-on-title="<?php echo e(translate('Are you sure you want to use third party gateway for sms')); ?>?"
                                                       data-off-title="<?php echo e(translate('Are you sure you want to use third party gateway for sms')); ?>?"
                                                       data-on-description="This action will make SMS Gateways your default SMS provider"
                                                       data-off-description="This action will make SMS Gateways your default SMS provider"
                                                       data-on-image="<?php echo e(asset('public/assets/admin-module/img/icons/swap.svg')); ?>"
                                                       data-off-image="<?php echo e(asset('public/assets/admin-module/img/icons/swap.svg')); ?>"
                                                >
                                                <label for="radio-option-1">
                                                    <h5 class="mb-1"><?php echo e(translate('3rd Party')); ?></h5>
                                                    <p class="fz-12 max-w-250"><?php echo e(translate('You have to setup a SMS module from below fist to active this feature')); ?></p>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="custom-radio">
                                                <input type="radio"
                                                       id="radio-option-2"
                                                       value="1"
                                                       <?php if($data['firebase_otp_verification']['live_values']['status'] == 1): echo 'checked'; endif; ?>
                                                       class="<?php echo e(env('APP_ENV') == 'demo' ? '' : 'update-status-modal'); ?>"
                                                       data-url="<?php echo e(route('admin.configuration.update-firebase-otp-status')); ?>"
                                                       data-on-title="<?php echo e(translate('Are you sure you want to use firebase for sms')); ?>?"
                                                       data-off-title="<?php echo e(translate('Are you sure you want to use firebase for sms')); ?>?"
                                                       data-on-description="This action will make Firebase your default SMS provider"
                                                       data-off-description="This action will make Firebase your default SMS provider"
                                                       data-on-image="<?php echo e(asset('public/assets/admin-module/img/icons/swap.svg')); ?>"
                                                       data-off-image="<?php echo e(asset('public/assets/admin-module/img/icons/swap.svg')); ?>"
                                                >
                                                <label for="radio-option-2">
                                                    <h5 class="mb-1"><?php echo e(translate('Firebase OTP')); ?></h5>
                                                    <p class="fz-12 max-w-250"><?php echo e(translate('Setup necessary')); ?> <a <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('firebase_view')): ?> href="<?php echo e(route('admin.configuration.third-party', 'firebase-configuration')); ?>" <?php endif; ?> target="_blank" class="text-primary text-decoration-underline"><?php echo e(translate('Firebase Configurations')); ?>.</a></p>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12 col-md-12 mb-15">
                    <?php if($publishedStatus == 1): ?>
                        <div class="col-md-12 mb-3">
                            <div class="card">
                                <div class="card-body d-flex justify-content-around">
                                    <h4 class="payment-module-warning">
                                        <i class="tio-info-outined"></i>
                                        <?php echo e(translate('Your current sms settings are disabled, because you
                                        have enabled
                                        sms gateway addon, To visit your currently active
                                        sms gateway settings please follow
                                        the link.')); ?></h4>
                                    <a href="<?php echo e(!empty($paymentUrl) ? $paymentUrl : ''); ?>"
                                       class="btn btn-outline-primary"><?php echo e(translate('settings')); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="row <?php echo e($publishedStatus == 1 ? 'disabled' : ''); ?>" id="gateway-cards">
                        <?php ($phoneVerificationStatus = (int) (login_setup('phone_verification'))->value ?? 0); ?>

                        <?php $__currentLoopData = $data['gateways']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $smsConfig): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12 col-md-6 mb-15">
                                <div class="card view-details-container">
                                    <div class="card-body p-20">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="">
                                                <h4 class="page-title mb-1">
                                                    <?php echo e(str_replace('_', ' ', $smsConfig['key_name'])); ?>

                                                </h4>
                                                <p class="fz-12">
                                                    <?php echo e(translate('setup')); ?> <?php echo e(str_replace('_', ' ', $smsConfig['key_name'])); ?> <?php echo e(translate('_as_sms_gateway')); ?>

                                                </p>
                                            </div>
                                            <div class="d-flex flex-sm-nowrap flex-wrap justify-content-end justify-content-end align-items-center gap-sm-3 gap-2">
                                                <div class="view-btn  order-sm-0 order-3 fz-12 text-primary cursor-pointer fw-semibold d-flex align-items-center gap-1">
                                                    <?php echo e(translate('View')); ?>

                                                    <i class="material-symbols-outlined fz-14">arrow_downward</i>
                                                </div>
                                                <div class="mb-0">
                                                    <label class="switcher">
                                                        <input type="checkbox"
                                                               <?php if($smsConfig['is_active']): echo 'checked'; endif; ?>
                                                               class="switcher_input <?php echo e($smsConfig['key_name']); ?>

                                                                    <?php echo e(env('APP_ENV') == 'demo' ? '' : ($phoneVerificationStatus == 1 && $smsConfig['is_active'] == 1 && $data['firebase_otp_verification']['live_values']['status'] == 0 ? 'check-phone-verification-status' : 'update-status-modal')); ?>"
                                                               data-id="<?php echo e($smsConfig['key_name']); ?>"
                                                               data-url="<?php echo e(route('admin.configuration.update-gateway-status', ['gateway' => $smsConfig['key_name'], 'status' => (int)!$smsConfig['is_active']])); ?>"
                                                               data-on-title="<?php echo e(translate('want_to_Turn_ON_').' '.ucwords(str_replace('_',' ',$smsConfig['key_name'])).' '.translate('_as_the_SMS_Gateway').'?'); ?>"
                                                               data-off-title="<?php echo e(translate('want_to_Turn_OFF_').' '.ucwords(str_replace('_',' ',$smsConfig['key_name'])).' '.translate('_as_the_SMS_Gateway').'?'); ?>"
                                                               data-on-description="<?php echo e(translate('if_enabled_system_can_use_this_SMS_Gateway')); ?>"
                                                               data-off-description="<?php echo e(translate('if_disabled_system_cannot_use_this_SMS_Gateway')); ?>"
                                                               data-on-image="<?php echo e(asset('public/assets/admin-module/img/modal/sms/'. $smsConfig['key_name'] . '.png' )); ?>"
                                                               data-off-image="<?php echo e(asset('public/assets/admin-module/img/icons/swap.svg')); ?>">
                                                        <span class="switcher_control <?php echo e(env('APP_ENV') == 'demo' ? 'disabled' : ''); ?>"  ></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <form class="view-details mt-20 third-party-data-form" action="<?php echo e(route('admin.configuration.sms-set')); ?>" method="POST" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <div class="discount-type body-bg rounded p-20 mb-20">
                                                <input name="gateway"
                                                       value="<?php echo e($smsConfig['key_name']); ?>"
                                                       class="hide-div">
                                                <input name="mode" value="live"
                                                       class="hide-div">
                                                <input type="hidden" id="<?php echo e($smsConfig['key_name']); ?>-status" name="status" value="<?php echo e((int)$smsConfig['is_active']); ?>">
                                                <?php ($skip = ['gateway','mode','status']); ?>
                                                <?php $__currentLoopData = $smsConfig['live_values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyName => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(!in_array($keyName, $skip)): ?>
                                                        <div class=" mb-30 mt-30">
                                                            <label class="mb-2 text-dark">
                                                                <?php echo e(ucwords(str_replace('_',' ',$keyName))); ?>

                                                                <span class="text-danger">*</span>
                                                            </label>
                                                            <input type="text"
                                                                   class="form-control"
                                                                   name="<?php echo e($keyName); ?>"
                                                                   placeholder="<?php echo e(ucwords(str_replace('_',' ',$keyName))); ?>"
                                                                   value="<?php echo e(env('APP_ENV')=='demo' ? '' : $value); ?>" required>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('configuration_update')): ?>
                                                <div class="d-flex justify-content-end gap-xl-3 gap-2">
                                                    <button type="reset" class="btn btn--secondary rounded"><?php echo e(translate('Reset')); ?></button>
                                                    <button type="<?php echo e(env('APP_ENV') == 'demo' ? 'button' : 'submit'); ?>"
                                                            class="btn btn--primary demo_check rounded">
                                                        <?php echo e(translate('Save')); ?>

                                                    </button>
                                                </div>
                                            <?php endif; ?>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="send__sms" tabindex="-1" aria-labelledby="send__smsLabel" aria-hidden="true">
        <?php
            $activeSMSGateway = collect($data['gateways'])->where('is_active', 1)->first()?->key_name ?? '';
        ?>
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body p-xl-4 p-3">
                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <div>
                            <h4 class="mb-xl-2 mb-1"><?php echo e(translate('Send Test SMS')); ?></h4>
                            <p><?php echo e(translate('Insert a valid phone number to get SMS')); ?></p>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="pick-map mb-20 p-12 rounded d-flex flex-md-nowrap flex-wrap align-items-center gap-1 bg-primary bg-opacity-10">
                        <img src="<?php echo e(asset('public/assets/admin-module/img/icons/focus_mode.svg')); ?>" alt="focus mode icon">
                        <p class="fz-12"> <?php echo e($data['firebase_otp_verification']['live_values']['status'] == 1 ? 'Firebase OTP' : $activeSMSGateway); ?> is configured for SMS. Please test to ensure you are receiving SMS messages correctly.</p>
                    </div>
                    <form action="javascript:" class="body-bg rounded p-20">
                        <label for="sent-mail" class="mb-2 text-dark"><?php echo e(translate('Phone number')); ?>

                            <i class="material-icons fz-14 text-light-gray" data-bs-toggle="tooltip"
                               data-bs-placement="top"
                               title="<?php echo e(translate('Phone number')); ?>"
                            >info</i>
                        </label>
                        <div class="d-flex align-items-center gap-1 iti__custom">
                             <input type="tel"
                                    class="form-control"
                                    id="exampleInputPhone"
                                    name="phone"
                                    placeholder="<?php echo e(translate('Phone_number')); ?>"
                                    value="" required>
                            <div class="">
                                <button type="button" id="send-mail" class="btn h-40 btn--primary rounded">
                                    <?php echo e(translate('Send SMS')); ?>

                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/azentech/public_html/serviceApp/Modules/BusinessSettingsModule/Resources/views/admin/configurations/third-party/config-sms.blade.php ENDPATH**/ ?>