<?php

namespace Modules\AdminModule\Traits;

trait AdminMenuWithRoutes
{
    public function adminMenuWithRoutes()
    {
        $result = [
            [
                'route_name' => 'Customized_Requests',
                'uri' => 'admin/booking/post?type=all',
                'full_route' => url('admin/booking/post?type=all'),
                "page_title" => 'Customized_Requests',
                "keywords" => 'Bookings',
                "type" => 'menu',
                "module" => "bookings",
                "sorting" => 1,
            ],
            [
                'route_name' => 'verify_requests',
                'uri' => 'admin/booking/list/verification?booking_status=pending&type=pending',
                'full_route' => url('admin/booking/list/verification?booking_status=pending&type=pending'),
                "page_title" => 'verify_requests',
                "keywords" => 'Bookings',
                "type" => 'menu',
                "module" => "bookings",
                "sorting" => 2,
            ],
            [
                'route_name' => 'Booking_Requests',
                'uri' => 'admin/booking/list?booking_status=pending&service_type=all',
                'full_route' => url('admin/booking/list?booking_status=pending&service_type=all'),
                "page_title" => 'Booking_Requests',
                "keywords" => 'Bookings',
                "type" => 'menu',
                "module" => "bookings",
                "sorting" => 3,
            ],
            [
                'route_name' => 'Offline_Payment_List',
                'uri' => 'admin/booking/list/offline-payment',
                'full_route' => url('admin/booking/list/offline-payment'),
                "page_title" => 'Offline_Payment_List',
                "keywords" => 'Bookings',
                "type" => 'menu',
                "module" => "bookings",
                "sorting" => 4,
            ],
            [
                'route_name' => 'Accepted',
                'uri' => 'admin/booking/list?booking_status=accepted&service_type=all',
                'full_route' => url('admin/booking/list?booking_status=accepted&service_type=all'),
                "page_title" => 'Accepted',
                "keywords" => 'Bookings',
                "type" => 'menu',
                "module" => "bookings",
                "sorting" => 5,
            ],
            [
                'route_name' => 'Ongoing',
                'uri' => 'admin/booking/list?booking_status=ongoing&service_type=all',
                'full_route' => url('admin/booking/list?booking_status=ongoing&service_type=all'),
                "page_title" => 'Ongoing',
                "keywords" => 'Ongoing, Bookings',
                "type" => 'menu',
                "module" => "bookings",
                "sorting" => 6,
            ],
            [
                'route_name' => 'Completed',
                'uri' => 'admin/booking/list?booking_status=completed&service_type=all',
                'full_route' => url('admin/booking/list?booking_status=completed&service_type=all'),
                "page_title" => 'Completed',
                "keywords" => 'Bookings',
                "type" => 'menu',
                "module" => "bookings",
                "sorting" => 7,
            ],
            [
                'route_name' => 'Canceled',
                'uri' => 'admin/booking/list?booking_status=canceled&service_type=all',
                'full_route' => url('admin/booking/list?booking_status=canceled&service_type=all'),
                "page_title" => 'Canceled',
                "keywords" => 'Bookings',
                "type" => 'menu',
                "module" => "bookings",
                "sorting" => 8,
            ],
            [
                'route_name' => 'discount_list',
                'uri' => 'admin/discount/list',
                'full_route' => url('admin/discount/list'),
                "page_title" => 'discount_list',
                "keywords" => 'discount list, Discounts',
                "type" => 'menu',
            ],
            [
                'route_name' => 'add_new_discount',
                'uri' => 'admin/discount/create',
                'full_route' => url('admin/discount/create'),
                "page_title" => 'add_new_discount',
                "keywords" => 'add new discount, Discounts',
                "type" => 'menu',
            ],
            [
                'route_name' => 'coupons',
                'uri' => 'admin/coupon/list',
                'full_route' => url('admin/coupon/list'),
                "page_title" => 'coupons',
                "keywords" => 'coupons, Coupons',
                "type" => 'menu',
            ],
            [
                'route_name' => 'coupon_list',
                'uri' => 'admin/coupon/list',
                'full_route' => url('admin/coupon/list'),
                "page_title" => 'coupon_list',
                "keywords" => 'coupon list, Coupons',
                "type" => 'menu',
            ],
            [
                'route_name' => 'add_new_coupon',
                'uri' => 'admin/coupon/create',
                'full_route' => url('admin/coupon/create'),
                "page_title" => 'add_new_coupon',
                "keywords" => 'add new coupon, Coupons',
                "type" => 'menu',
            ],
            [
                'route_name' => 'bonus_list',
                'uri' => 'admin/bonus/list',
                'full_route' => url('admin/bonus/list'),
                "page_title" => 'bonus_list',
                "keywords" => 'Bonus list, Wallet bonus',
                "type" => 'menu',
            ],
            [
                'route_name' => 'add_new_bonus',
                'uri' => 'admin/bonus/create',
                'full_route' => url('admin/bonus/create'),
                "page_title" => 'add_new_bonus',
                "keywords" => 'add new bonus, Wallet bonus',
                "type" => 'menu',
            ],
            [
                'route_name' => 'campaigns',
                'uri' => 'admin/campaign/list',
                'full_route' => url('admin/campaign/list'),
                "page_title" => 'campaigns',
                "keywords" => 'campaigns, Campaigns',
                "type" => 'menu',
            ],
            [
                'route_name' => 'add_new_campaign',
                'uri' => 'admin/campaign/create',
                'full_route' => url('admin/campaign/create'),
                "page_title" => 'add_new_campaign',
                "keywords" => 'add new campaign, Campaigns',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Ads_list',
                'uri' => 'admin/advertisements/ads-list?status=all',
                'full_route' => url('admin/advertisements/ads-list?status=all'),
                "page_title" => 'Ads_list',
                "keywords" => 'Ads list, Advertisements',
                "type" => 'menu',
            ],
            [
                'route_name' => 'New_Ads_Request',
                'uri' => 'admin/advertisements/new-ads-request?status=new',
                'full_route' => url('admin/advertisements/new-ads-request?status=new'),
                "page_title" => 'New_Ads_Request',
                "keywords" => 'New Ads Request, Advertisements',
                "type" => 'menu',
            ],
            [
                'route_name' => 'promotional_banners',
                'uri' => 'admin/banner/create',
                'full_route' => url('admin/banner/create'),
                "page_title" => 'promotional_banners',
                "keywords" => 'Promotional Banners',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Send_Notifications',
                'uri' => 'admin/push-notification/create',
                'full_route' => url('admin/push-notification/create'),
                "page_title" => 'Send_Notifications',
                "keywords" => 'Send Notifications',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Onboarding_Request',
                'uri' => 'admin/provider/onboarding-request?status=onboarding',
                'full_route' => url('admin/provider/onboarding-request?status=onboarding'),
                "page_title" => 'Onboarding_Request',
                "keywords" => 'Onboarding Requests',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Provider_List',
                'uri' => 'admin/provider/list?status=all',
                'full_route' => url('admin/provider/list?status=all'),
                "page_title" => 'Provider_List',
                "keywords" => 'Provider List, Providers',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Add_New_Provider',
                'uri' => 'admin/provider/create',
                'full_route' => url('admin/provider/create'),
                "page_title" => 'Add_New_Provider',
                "keywords" => 'Add new provider, Providers',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Withdraw_Requests',
                'uri' => 'admin/withdraw/request/list?status=all',
                'full_route' => url('admin/withdraw/request/list?status=all'),
                "page_title" => 'Withdraw_Requests',
                "keywords" => 'Withdraw Requests, Withdraws',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Withdraw method setup',
                'uri' => 'admin/withdraw/method/create',
                'full_route' => url('admin/withdraw/method/create'),
                "page_title" => 'Withdraw method setup',
                "keywords" => 'Withdraw method setup, Withdraws',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Service_Zones_Setup',
                'uri' => 'admin/zone/create',
                'full_route' => url('admin/zone/create'),
                "page_title" => 'Service_Zones_Setup',
                "keywords" => 'Service Zones Setup',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Category_Setup',
                'uri' => 'admin/category/create',
                'full_route' => url('admin/category/create'),
                "page_title" => 'Category_Setup',
                "keywords" => 'Category Setup, Categories',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Sub_Category_Setup',
                'uri' => 'admin/sub-category/create',
                'full_route' => url('admin/sub-category/create'),
                "page_title" => 'Sub_Category_Setup',
                "keywords" => 'Sub Category Setup, Categories',
                "type" => 'menu',
            ],
            [
                'route_name' => 'service_list',
                'uri' => 'admin/service/list',
                'full_route' => url('admin/service/list'),
                "page_title" => 'service_list',
                "keywords" => 'Services',
                "type" => 'menu',
                "module" => "services",
                "sorting" => 1,
            ],
            [
                'route_name' => 'add_new_servmy goaice',
                'uri' => 'admin/service/create',
                'full_route' => url('admin/service/create'),
                "page_title" => 'add_new_service',
                "keywords" => 'Services',
                "type" => 'menu',
                "module" => "services",
                "sorting" => 2,
            ],
            [
                'route_name' => 'New_Service_Requests',
                'uri' => 'admin/service/request/list',
                'full_route' => url('admin/service/request/list'),
                "page_title" => 'New_Service_Requests',
                "keywords" => 'Services',
                "type" => 'menu',
                "module" => "services",
                "sorting" => 3,
            ],
            [
                'route_name' => 'customer_list',
                'uri' => 'admin/customer/list',
                'full_route' => url('admin/customer/list'),
                "page_title" => 'customer_list',
                'keywords' => 'Customers',
                "type" => 'menu',
            ],
            [
                'route_name' => 'add_new_customer',
                'uri' => 'admin/customer/create',
                'full_route' => url('admin/customer/create'),
                "page_title" => 'add_new_customer',
                "keywords" => 'Customers',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Add_Fund_to_Wallet',
                'uri' => 'admin/customer/wallet/add-fund',
                'full_route' => url('admin/customer/wallet/add-fund'),
                "page_title" => 'Add_Fund_to_Wallet',
                "keywords" => 'Add Fund to Wallet, Customer wallet',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Wallet_Transactions',
                'uri' => 'admin/customer/wallet/report',
                'full_route' => url('admin/customer/wallet/report'),
                "page_title" => 'Wallet_Transactions',
                "keywords" => 'Wallet Transactions, Customer wallet',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Loyalty_Points_Transactions',
                'uri' => 'admin/customer/loyalty-point/report',
                'full_route' => url('admin/customer/loyalty-point/report'),
                "page_title" => 'Loyalty_Points_Transactions',
                "keywords" => 'Loyalty Points Transactions, Loyalty point',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Subscribed_Newsletter',
                'uri' => 'admin/customer/newsletter/list',
                'full_route' => url('admin/customer/newsletter/list'),
                "page_title" => 'Subscribed_Newsletter',
                "keywords" => 'Subscribed Newsletter',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Subscribed_Newsletter',
                'uri' => 'admin/role/list',
                'full_route' => url('admin/role/list'),
                "page_title" => 'Subscribed_Newsletter',
                "keywords" => 'Subscribed Newsletter',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Employee_Role_Setup',
                'uri' => 'admin/role/list',
                'full_route' => url('admin/role/list'),
                "page_title" => 'Employee_Role_Setup',
                "keywords" => 'Employee Role Setup',
                "type" => 'menu',
            ],
            [
                'route_name' => 'employee_list',
                'uri' => 'admin/employee/list',
                'full_route' => url('admin/employee/list'),
                "page_title" => 'employee_list',
                "keywords" => 'Employee list',
                "type" => 'menu',
            ],
            [
                'route_name' => 'add_new_employee',
                'uri' => 'admin/employee/create',
                'full_route' => url('admin/employee/create'),
                "page_title" => 'add_new_employee',
                "keywords" => 'Add new employee',
                "type" => 'menu',
            ],
            [
                'route_name' => 'All_Transactions',
                'uri' => 'admin/transaction/list?trx_type=all',
                'full_route' => url('admin/transaction/list?trx_type=all'),
                "page_title" => 'All_Transactions',
                "keywords" => 'All Transactions',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Transaction_Reports',
                'uri' => 'admin/report/transaction?transaction_type=all',
                'full_route' => url('admin/report/transaction?transaction_type=all'),
                "page_title" => 'Transaction Reports',
                "keywords" => 'Reports',
                "type" => 'menu',
                "module" => "reports",
                "sorting" => 1,
            ],
            [
                'route_name' => 'Business_Reports',
                'uri' => 'admin/report/business/overview',
                'full_route' => url('admin/report/business/overview'),
                "page_title" => 'Business_Reports',
                "keywords" => 'Reports',
                "type" => 'menu',
                "module" => "reports",
                "sorting" => 2,
            ],
            [
                'route_name' => 'Booking_Reports',
                'uri' => 'admin/report/booking',
                'full_route' => url('admin/report/booking'),
                "page_title" => 'Booking_Reports',
                "keywords" => 'Reports',
                "type" => 'menu',
                "module" => "reports",
                "sorting" => 3,
            ],
            [
                'route_name' => 'Provider_Reports',
                'uri' => 'admin/report/provider',
                'full_route' => url('admin/report/provider'),
                "page_title" => 'Provider_Reports',
                "keywords" => 'Reports',
                "type" => 'menu',
                "module" => "reports",
                "sorting" => 4,
            ],
            [
                'route_name' => 'Keyword_Search',
                'uri' => 'admin/analytics/search/keyword',
                'full_route' => url('admin/analytics/search/keyword'),
                "page_title" => 'Keyword_Search',
                "keywords" => 'Keyword Search, Analytics',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Customer_Search',
                'uri' => 'admin/analytics/search/customer',
                'full_route' => url('admin/analytics/search/customer'),
                "page_title" => 'Customer_Search',
                "keywords" => 'Customer Search, Analytics',
                "type" => 'menu',
            ],
            [
                'route_name' => 'System_Addons',
                'uri' => 'admin/addon',
                'full_route' => url('admin/addon'),
                "page_title" => 'System_Addons',
                "keywords" => 'System Addon',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Business_settings',
                'uri' => 'admin/business-settings/get-business-information',
                'full_route' => url('admin/business-settings/get-business-information'),
                "page_title" => 'Business_settings',
                "keywords" => 'Business Settings, Settings management',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Login_Setup',
                'uri' => 'admin/business-settings/login/setup',
                'full_route' => url('admin/business-settings/login/setup'),
                "page_title" => 'Login_Setup',
                "keywords" => 'Login Setup, Settings management',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Rules_&_Restrictions',
                'uri' => 'admin/business-settings/login/setup?web_page=admin_provider_login',
                'full_route' => url('admin/business-settings/login/setup?web_page=admin_provider_login'),
                "page_title" => 'Rules_&_Restrictions',
                "keywords" => 'Rules and Restrictions, Settings management',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Notification_Channel',
                'uri' => 'admin/business-settings/notification-channel?notification_type=user',
                'full_route' => url('admin/business-settings/notification-channel?notification_type=user'),
                "page_title" => 'Notification_Channel',
                "keywords" => 'Notification Channel, Settings management',
                "type" => 'menu',
            ],
            [
                'route_name' => '404_Logs',
                'uri' => 'admin/business-settings/seo-setting?page_type=error_logs',
                'full_route' => url('admin/business-settings/seo-setting?page_type=error_logs'),
                "page_title" => '404_Logs',
                "keywords" => '404 Logs, Settings management',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Cron_Job',
                'uri' => 'admin/business-settings/cron-job',
                'full_route' => url('admin/business-settings/cron-job'),
                "page_title" => 'Cron_Job',
                "keywords" => 'Cron job, Settings management',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Subscription_Package',
                'uri' => 'admin/subscription/package/list',
                'full_route' => url('admin/subscription/package/list'),
                "page_title" => 'Subscription_Package',
                "keywords" => 'Subscription Package, Subscription management',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Subscriber_List',
                'uri' => 'admin/subscription/subscriber/list',
                'full_route' => url('admin/subscription/subscriber/list'),
                "page_title" => 'Subscriber_List',
                "keywords" => 'Subscriber List, Subscription management',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Settings',
                'uri' => 'admin/subscription/settings',
                'full_route' => url('admin/subscription/settings'),
                "page_title" => 'Settings',
                "keywords" => 'Settings, Subscription management',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Button_&_links',
                'uri' => 'admin/business-settings/get-landing-information?web_page=button_and_links',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=button_and_links'),
                "page_title" => 'Button_&_links',
                "keywords" => 'Button & links, Button and links',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Speciality',
                'uri' => 'admin/business-settings/get-landing-information?web_page=speciality',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=speciality'),
                "page_title" => 'Speciality',
                "keywords" => 'Speciality',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Testimonial',
                'uri' => 'admin/business-settings/get-landing-information?web_page=testimonial',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=testimonial'),
                "page_title" => 'Testimonial',
                "keywords" => 'Testimonial',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Features',
                'uri' => 'admin/business-settings/get-landing-information?web_page=features',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=features'),
                "page_title" => 'Features',
                "keywords" => 'Features',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Images',
                'uri' => 'admin/business-settings/get-landing-information?web_page=images',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=images'),
                "page_title" => 'Images',
                "keywords" => 'Images',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Background',
                'uri' => 'admin/business-settings/get-landing-information?web_page=background',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=background'),
                "page_title" => 'Background',
                "keywords" => 'Background',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Social_Media',
                'uri' => 'admin/business-settings/get-landing-information?web_page=social_media',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=social_media'),
                "page_title" => 'Social_Media',
                "keywords" => 'Social Media',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Meta',
                'uri' => 'admin/business-settings/get-landing-information?web_page=meta',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=meta'),
                "page_title" => 'Meta',
                "keywords" => 'Meta',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Web_App',
                'uri' => 'admin/business-settings/get-landing-information?web_page=web_app',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=web_app'),
                "page_title" => 'Web_App',
                "keywords" => 'Web App',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Web_App_image',
                'uri' => 'admin/business-settings/get-landing-information?web_page=web_app_image',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=web_app_image'),
                "page_title" => 'Web_App_Image',
                "keywords" => 'Web App image',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Push_notification',
                'uri' => 'admin/configuration/get-notification-setting?type=customers',
                'full_route' => url('admin/configuration/get-notification-setting?type=customers'),
                "page_title" => 'Push_notification',
                "keywords" => 'Push notification, Configuration',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Providers',
                'uri' => 'admin/configuration/get-notification-setting?type=providers',
                'full_route' => url('admin/configuration/get-notification-setting?type=providers'),
                "page_title" => 'Providers',
                "keywords" => 'Providers',
                "type" => 'menu',
            ],
            [
                'route_name' => 'other_configuration',
                'uri' => 'admin/configuration/third-party/map-api',
                'full_route' => url('admin/configuration/third-party/map-api'),
                "page_title" => 'other_configuration',
                "keywords" => 'other configuration, Configuration',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Other_configuration',
                'uri' => 'admin/configuration/third-party/map-api',
                'full_route' => url('admin/configuration/third-party/map-api'),
                "page_title" => 'Other_configuration',
                "keywords" => 'Other configuration, Configuration',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Firebase',
                'uri' => 'admin/configuration/third-party/firebase-configuration',
                'full_route' => url('admin/configuration/third-party/firebase-configuration'),
                "page_title" => 'Firebase',
                "keywords" => 'Firebase',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Recaptcha',
                'uri' => 'admin/configuration/third-party/recaptcha',
                'full_route' => url('admin/configuration/third-party/recaptcha'),
                "page_title" => 'Recaptcha',
                "keywords" => 'Recaptcha',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Apple_login',
                'uri' => 'admin/configuration/third-party/apple-login',
                'full_route' => url('admin/configuration/third-party/apple-login'),
                "page_title" => 'Apple_login',
                "keywords" => 'Apple login',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Email_config',
                'uri' => 'admin/configuration/third-party/email-config',
                'full_route' => url('admin/configuration/third-party/email-config'),
                "page_title" => 'Email_config',
                "keywords" => 'Email config',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Sms_config',
                'uri' => 'admin/configuration/third-party/sms_config',
                'full_route' => url('admin/configuration/third-party/sms_config'),
                "page_title" => 'Sms_config',
                "keywords" => 'Sms config',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Payment_methods',
                'uri' => 'admin/configuration/third-party/payment_config?type=digital_payment',
                'full_route' => url('admin/configuration/third-party/payment_config?type=digital_payment'),
                "page_title" => 'Payment_methods',
                "keywords" => 'Payment methods,Payment config',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Storage_connection',
                'uri' => 'admin/configuration/third-party/storage_connection',
                'full_route' => url('admin/configuration/third-party/storage_connection'),
                "page_title" => 'Storage_connection',
                "keywords" => 'Storage connection',
                "type" => 'menu',
            ],
            [
                'route_name' => 'App_settings',
                'uri' => 'admin/configuration/third-party/app_settings',
                'full_route' => url('admin/configuration/third-party/app_settings'),
                "page_title" => 'App_settings',
                "keywords" => 'App Settings',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Language_setup',
                'uri' => 'admin/configuration/language-setup',
                'full_route' => url('admin/configuration/language-setup'),
                "page_title" => 'Language_setup',
                "keywords" => 'Language setup, Configuration',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Business_pages',
                'uri' => 'admin/business-page-setup/list',
                'full_route' => url('admin/business-page-setup/list'),
                "page_title" => 'Business_pages',
                "keywords" => 'Page & media',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Social_media',
                'uri' => 'admin/social-media/index',
                'full_route' => url('admin/social-media/index'),
                "page_title" => 'Social_media',
                "keywords" => 'Page & media',
                "type" => 'menu',
            ],
            [
                'route_name' => 'landing_page_settings',
                'uri' => 'admin/business-settings/get-landing-information?web_page=text_setup',
                'full_route' => url('admin/business-settings/get-landing-information?web_page=text_setup'),
                "page_title" => 'landing_page_settings',
                "keywords" => 'Page & media',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Gallery',
                'uri' => 'admin/business-settings/get-gallery-setup',
                'full_route' => url('admin/business-settings/get-gallery-setup'),
                "page_title" => 'Gallery',
                "keywords" => 'Gallery',
                "type" => 'menu',
            ],
            [
                'route_name' => 'Backup_database',
                'uri' => 'admin/business-settings/get-database-backup',
                'full_route' => url('admin/business-settings/get-database-backup'),
                "page_title" => 'Backup_database',
                "keywords" => 'Backup database, database backup',
                "type" => 'menu',
            ],
            [
               'route_name' => 'Ai_configuration',
                'uri' => 'admin/configuration/ai-configuration',
                'full_route' => url('admin/configuration/ai-configuration'),
                "page_title" => 'AI_Configuration',
                "keywords" => 'AI , AI configuration',
                "type" => 'menu',
            ],
        ];

        if(count(config('addon_admin_routes'))>0) {
            if (count(config('addon_admin_routes')) > 0) {
                $result[] = [
                    'route_name' => 'Payment_setup',
                    'uri' => 'admin/payment/configuration/addon-payment-get',
                    'full_route' => url('admin/payment/configuration/addon-payment-get'),
                    "page_title" => 'Payment_setup',
                    "keywords" => 'Addon Menus',
                    "type" => 'menu',
                ];

                $result[] = [
                    'route_name' => 'Sms_setup',
                    'uri' => 'admin/sms/configuration/addon-sms-get',
                    'full_route' => url('admin/sms/configuration/addon-sms-get'),
                    "page_title" => 'Sms_setup',
                    "keywords" => 'Addon Menus',
                    "type" => 'menu',
                ];
            }

        }

        return collect($result)->map(function ($item) {
         return [
                "page_title" => $item['route_name'],
                'page_title_value' => $item['route_name'] ?? null,
                'key' => base64_encode($item['uri']),
                'uri' => $item['uri'],
                'uri_count' => count(explode('/', $item['uri'])),
                'full_route' => $item['full_route'] ?? '',
                'type' => $item['type'],
                'priority' => $item['priority'] ?? 1,
                'sorting' => $item['sorting'] ?? '',
                "keywords" => $item['keywords'],
            ];
        });
    }
}
