<?php $__env->startSection('title', translate('Update_Food')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="<?php echo e(dynamicAsset('public/assets/admin/css/tags-input.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(dynamicAsset('public/assets/admin/css/AI/animation/product/ai-sidebar.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-header-title"><i class="tio-edit"></i>
                <?php echo e(translate('messages.food_update')); ?>

            </h1>
        </div>


        <?php ($openai_config=\App\CentralLogics\Helpers::get_business_settings('openai_config')); ?>

        <form action="javascript:" method="post" id="product_form" enctype="multipart/form-data">
            <input type="hidden" id="request_type" value="admin">
            <?php echo csrf_field(); ?>
            <input type="hidden" id="removedVariationIDs" name="removedVariationIDs" value="">
            <input type="hidden" id="removedVariationOptionIDs" name="removedVariationOptionIDs" value="">
            <div class="row g-2">


                <?php if ($__env->exists('admin-views.product.partials._title_and_discription')) echo $__env->make('admin-views.product.partials._title_and_discription', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <div class="col-lg-6">
                    <div class="card shadow--card-2 border-0 h-100">
                        <div class="card-body">
                            <div class="d-flex flex-column align-items-center gap-3">
                                <p class="mb-0"><?php echo e(translate('Food_Image')); ?> </p>
                                <div class="image-box">
                                    <label for="image-input"
                                           class="d-flex flex-column align-items-center justify-content-center h-100 cursor-pointer gap-2">
                                        <img class="upload-icon initial-26" src="<?php echo e($product['image_full_url']); ?>"
                                             alt="Upload Icon">
                                        <img src="#" alt="Preview Image" class="preview-image">
                                    </label>
                                    <button type="button" class="delete_image">
                                        <i class="tio-delete"></i>
                                    </button>
                                    <input type="file" id="image-input" name="image" accept="image/*" hidden>
                                </div>

                                <p class="opacity-75 max-w220 mx-auto text-center">
                                    <?php echo e(translate('Image format - jpg png jpeg gif Image Size -maximum size 2 MB Image Ratio - 1:1')); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if ($__env->exists('admin-views.product.partials._category_and_general')) echo $__env->make('admin-views.product.partials._category_and_general', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php if ($__env->exists('admin-views.product.partials._price_and_stock')) echo $__env->make('admin-views.product.partials._price_and_stock', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <div class="col-lg-12">
                    <div class="general_wrapper">
                        <div class="outline-wrapper">
                            <div class="card shadow--card-2 border-0 bg-animate">
                                <div class="card-header flex-wrap">
                                    <h5 class="card-title">
                                        <span class="card-header-icon mr-2">
                                            <i class="tio-canvas-text"></i>
                                        </span>
                                        <span><?php echo e(translate('messages.food_variations')); ?></span>
                                    </h5>
                                    <div>
                                        <a class="btn text--primary-2" id="add_new_option_button">
                                            <?php echo e(translate('add_new_variation')); ?>

                                            <i class="tio-add"></i>
                                        </a>
                                        <?php if(isset($openai_config) && data_get($openai_config, 'status') == 1): ?>
                                            <button type="button"
                                                    class="btn bg-white text-primary opacity-1 generate_btn_wrapper variation_setup_auto_fill"
                                                    id="variation_setup_auto_fill"
                                                    data-route="<?php echo e(route('admin.product.variation-setup-auto-fill')); ?>"
                                                    data-lang="en">
                                                <div class="btn-svg-wrapper">
                                                    <img width="18" height="18" class=""
                                                         src="<?php echo e(dynamicAsset('public/assets/admin/img/svg/blink-right-small.svg')); ?>"
                                                         alt="">
                                                </div>
                                                <span class="ai-text-animation d-none" role="status">
                                                <?php echo e(translate('Just_a_second')); ?>

                                            </span>
                                                <span class="btn-text"><?php echo e(translate('Generate')); ?></span>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <input type="hidden" name="remove_all_old_variations" value="0"
                                       id="remove_all_old_variations">
                                <div class="card-body">
                                    <div class="row g-2">
                                        <div class="col-md-12">
                                            <div id="add_new_option">
                                                <?php if(isset($product->variations)): ?>
                                                    <?php $__currentLoopData = json_decode($product->variations, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_choice_options => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(isset($item['price'])): ?>
                                                            <?php break; ?>

                                                        <?php else: ?>
                                                            <?php echo $__env->make(
                                                                'admin-views.product.partials._new_variations',
                                                                ['item' => $item, 'key' => $key_choice_options + 1]
                                                            , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if ($__env->exists('admin-views.product.partials._ai_sidebar')) echo $__env->make('admin-views.product.partials._ai_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <div class="col-lg-12">
                    <?php if ($__env->exists('admin-views.product.partials._seo-section-edit')) echo $__env->make('admin-views.product.partials._seo-section-edit', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>


                <div class="col-lg-12">
                    <div class="btn--container justify-content-end">
                        <button type="reset" id="reset_btn"
                                class="btn btn--reset"><?php echo e(translate('messages.reset')); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo e(translate('messages.submit')); ?></button>
                    </div>
                </div>
            </div>
        </form>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script_2'); ?>

    <script>
        var count = <?php echo e(isset($product->variations) ? count(json_decode($product->variations, true)) : 0); ?>;
    </script>
    <script src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/js/tags-input.min.js"></script>
    <script src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/js/view-pages/product-index.js"></script>

    <script src="<?php echo e(dynamicAsset('public/assets/admin/js/AI/products/product-title-autofill.js')); ?>"></script>
    <script src="<?php echo e(dynamicAsset('public/assets/admin/js/AI/products/product-description-autofill.js')); ?>"></script>
    <script src="<?php echo e(dynamicAsset('public/assets/admin/js/AI/products/general-setup-autofill.js')); ?>"></script>
    <script src="<?php echo e(dynamicAsset('public/assets/admin/js/AI/products/product-others-autofill.js')); ?>"></script>
    <script src="<?php echo e(dynamicAsset('public/assets/admin/js/AI/products/variation-setup-auto-fill.js')); ?>"></script>
    

    <script src="<?php echo e(dynamicAsset('public/assets/admin/js/AI/products/ai-sidebar.js')); ?>"></script>

    <script src="<?php echo e(dynamicAsset('/public/assets/admin/js/AI/products/compressor/image-compressor.js')); ?>"></script>
    <script src="<?php echo e(dynamicAsset('/public/assets/admin/js/AI/products/compressor/compressor.min.js')); ?>"></script>


    <script>
        "use strict";


        $('#stock_type').on('change', function () {
            if ($(this).val() == 'unlimited') {
                $('.stock_disable').prop('readonly', true).prop('required', false).attr('placeholder',
                    '<?php echo e(translate('Unlimited')); ?>').val('');
                $('.hide_this').addClass('d-none');
            } else {
                $('.stock_disable').prop('readonly', false).prop('required', true).attr('placeholder',
                    '<?php echo e(translate('messages.Ex:_100')); ?>');
                $('.hide_this').removeClass('d-none');
            }
        });

        updatestockCount();

        function updatestockCount() {
            if ($('#stock_type').val() == 'unlimited') {
                $('.stock_disable').prop('readonly', true).prop('required', false).attr('placeholder',
                    '<?php echo e(translate('Unlimited')); ?>').val('');
                $('.hide_this').addClass('d-none');
            } else {
                $('.stock_disable').prop('readonly', false).prop('required', true).attr('placeholder',
                    '<?php echo e(translate('messages.Ex:_100')); ?>');
                $('.hide_this').removeClass('d-none');
            }
        }


        $('#restaurant_id').on('change', function () {
            let route = '<?php echo e(url('/')); ?>/admin/restaurant/get-addons?data[]=0&restaurant_id=';
            let restaurant_id = $(this).val();
            let id = 'add_on';
            getRestaurantData(route, restaurant_id, id);

        });
        $('.get-request').on('change', function () {
            let route = '<?php echo e(url('/')); ?>/admin/food/get-categories?parent_id=' + $(this).val();
            let id = 'sub-categories';
            getRequest(route, id);
        });

        function getRestaurantData(route, restaurant_id, id) {
            $.get({
                url: route + restaurant_id,
                dataType: 'json',
                success: function (data) {
                    $('#' + id).empty().append(data.options);
                },
            });
        }

        function getRequest(route, id) {
            $.get({
                url: route,
                dataType: 'json',
                success: function (data) {
                    $('#' + id).empty().append(data.options);
                },
            });
        }

        $(document).ready(function () {
            setTimeout(function () {
                let category = $("#category-id").val();
                let sub_category = '<?php echo e(count($product_category) >= 2 ? $product_category[1]->id : ''); ?>';
                let sub_sub_category =
                    '<?php echo e(count($product_category) >= 3 ? $product_category[2]->id : ''); ?>';
                getRequest('<?php echo e(url('/')); ?>/admin/food/get-categories?parent_id=' + category +
                    '&sub_category=' + sub_category, 'sub-categories');
                getRequest('<?php echo e(url('/')); ?>/admin/food/get-categories?parent_id=' + sub_category +
                    '&sub_category=' + sub_sub_category, 'sub-sub-categories');

            }, 1000)

            <?php if(count(json_decode($product['add_ons'], true)) > 0): ?>
            getRestaurantData(
                '<?php echo e(url('/')); ?>/admin/restaurant/get-addons?<?php $__currentLoopData = json_decode($product['add_ons'], true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>data[]=<?php echo e($addon); ?>& <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> restaurant_id=',
                '<?php echo e($product['restaurant_id']); ?>', 'add_on');
            <?php else: ?>
            getRestaurantData('<?php echo e(url('/')); ?>/admin/restaurant/get-addons?data[]=0&restaurant_id=',
                '<?php echo e($product['restaurant_id']); ?>', 'add_on');
            <?php endif; ?>
        });

        $(document).on('ready', function () {
            $('.js-select2-custom').each(function () {
                var select2 = $.HSCore.components.HSSelect2.init($(this));
            });
        });

        $('.js-data-example-ajax').select2({
            ajax: {
                url: '<?php echo e(url('/')); ?>/admin/restaurant/get-restaurants',
                data: function (params) {
                    return {
                        q: params.term, // search term
                        page: params.page
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                __port: function (params, success, failure) {
                    var $request = $.ajax(params);

                    $request.then(success);
                    $request.fail(failure);

                    return $request;
                }
            }
        });

        $(document).ready(function () {
            $("#add_new_option_button").click(function () {
                add_new_option_button();
            });
        });

        function add_new_option_button() {
            $('#empty-variation').hide();
            count++;
            let add_option_view = `
                        <div class="__bg-F8F9FC-card view_new_option mb-2">
                            <div>
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <label class="form-check form--check">
                                        <input id="options[` + count + `][required]" name="options[` + count + `][required]"
                                            class="form-check-input" type="checkbox">
                                        <span class="form-check-label"><?php echo e(translate('Required')); ?></span>
                                    </label>
                                    <div>
                                        <button type="button" class="btn btn-danger btn-sm delete_input_button"
                                            title="<?php echo e(translate('Delete')); ?>">
                                            <i class="tio-add-to-trash"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="row g-2">
                                    <div class="col-xl-4 col-lg-6">
                                        <label for=""><?php echo e(translate('name')); ?>&nbsp;<span class="form-label-secondary text-danger"
                                                data-toggle="tooltip" data-placement="right"
                                                data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                            </span></label>
                                        <input required name=options[` + count + `][name] class="form-control new_option_name" type="text"
                                            data-count="` + count + `">
                                    </div>

                                    <div class="col-xl-4 col-lg-6">
                                        <div>
                                            <label class="input-label text-capitalize d-flex align-items-center"><span
                                                    class="line--limit-1"><?php echo e(translate('messages.Variation_Selection_Type')); ?> </span>
                                            </label>
                                            <div class="resturant-type-group px-0">
                                                <label class="form-check form--check mr-2 mr-md-4">
                                                    <input class="form-check-input show_min_max" data-count="` + count + `" type="radio"
                                                        value="multi" name="options[` + count + `][type]" id="type` + count + `" checked>
                                                    <span class="form-check-label">
                                                        <?php echo e(translate('Multiple Selection')); ?>

            </span>
        </label>

        <label class="form-check form--check mr-2 mr-md-4">
            <input class="form-check-input hide_min_max" data-count="` + count + `" type="radio"
                                                        value="single" name="options[` + count + `][type]" id="type` + count + `">
                                                    <span class="form-check-label">
                                                        <?php echo e(translate('Single Selection')); ?>

            </span>
        </label>
    </div>
</div>
</div>
<div class="col-xl-4 col-lg-6">
<div class="row g-2">
    <div class="col-6">
        <label for=""><?php echo e(translate('Min')); ?></label>
                                                <input id="min_max1_` + count + `" required name="options[` + count + `][min]"
                                                    class="form-control" type="number" min="1">
                                            </div>
                                            <div class="col-6">
                                                <label for=""><?php echo e(translate('Max')); ?></label>
                                                <input id="min_max2_` + count + `" required name="options[` + count + `][max]"
                                                    class="form-control" type="number" min="1">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="option_price_` + count + `">
                                    <div class="bg-white border rounded p-3 pb-0 mt-3">
                                        <div id="option_price_view_` + count + `">
                                            <div class="row g-3 add_new_view_row_class mb-3">
                                                <div class="col-md-3 col-sm-6">
                                                    <label for=""><?php echo e(translate('Option_name')); ?> &nbsp;<span
                                                            class="form-label-secondary text-danger" data-toggle="tooltip"
                                                            data-placement="right"
                                                            data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                                        </span></label>
                                                    <input class="form-control" required type="text"
                                                        name="options[` + count + `][values][0][label]" id="">
                                                </div>
                                                <div class="col-md-3 col-sm-6">
                                                    <label for=""><?php echo e(translate('Additional_price')); ?>

            (<?php echo e(\App\CentralLogics\Helpers::currency_symbol()); ?>)&nbsp;<span
                                                            class="form-label-secondary text-danger" data-toggle="tooltip"
                                                            data-placement="right"
                                                            data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                                        </span></label>
                                                    <input class="form-control" required type="number" min="0" step="0.01"
                                                        name="options[` + count + `][values][0][optionPrice]" id="">
                                                </div>
                                                <div class="col-md-3 col-sm-6 hide_this">
                                                    <label for=""><?php echo e(translate('Stock')); ?></label>
                                                    <input class="form-control stock_disable count_stock" required type="number"
                                                        min="0" max="9999999" name="options[` + count + `][values][0][total_stock]"
                                                        id="">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row mt-3 p-3 mr-1 d-flex " id="add_new_button_` + count + `">
                                            <button type="button" class="btn btn--primary btn-outline-primary add_new_row_button"
                                                data-count="` + count + `"><?php echo e(translate('Add_New_Option')); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                `;

            $("#add_new_option").append(add_option_view);
            updatestockCount();
        }


        function add_new_row_button(data) {
            var countRow = 1 + $('#option_price_view_' + data).children('.add_new_view_row_class').length;
            let add_new_row_view = `
            <div class="row add_new_view_row_class mb-3 position-relative pt-3 pt-sm-0">
                <div class="col-md-3 col-sm-5">
                        <label for=""><?php echo e(translate('Option_name')); ?>  &nbsp;<span class="form-label-secondary text-danger"
                                data-toggle="tooltip" data-placement="right"
                                data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                </span></label>
                        <input class="form-control" required type="text" name="options[` + data + `][values][` +
                countRow + `][label]" id="">
                    </div>
                    <div class="col-md-3 col-sm-5">
                        <label for=""><?php echo e(translate('Additional_price')); ?>  &nbsp;<span class="form-label-secondary text-danger"
                                data-toggle="tooltip" data-placement="right"
                                data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                </span></label>
                        <input class="form-control"  required type="number" min="0" step="0.01" name="options[` +
                data +
                `][values][` + countRow +
                `][optionPrice]" id="">
                    </div>
                    <div class="col-md-3 col-sm-5 hide_this">
                        <label for=""><?php echo e(translate('Stock')); ?>  </label>
                        <input class="form-control stock_disable count_stock"  required type="number" min="0" max="99999999"  name="options[` +
                data +
                `][values][` + countRow + `][total_stock]" id="">
                    </div>

                    <input type="hidden" hidden name="options[` +
                data +
                `][values][` + countRow + `][option_id]" value="null" >

                    <div class="col-sm-2 max-sm-absolute">
                        <label class="d-none d-sm-block">&nbsp;</label>
                        <div class="mt-1">
                            <button type="button" class="btn btn-danger btn-sm deleteRow"
                                title="<?php echo e(translate('Delete')); ?>">
                                <i class="tio-add-to-trash"></i>
                            </button>
                        </div>
                </div>
            </div>`;
            $('#option_price_view_' + data).append(add_new_row_view);
            updatestockCount();

        }

        let removedVariationIDs = [];
        let removedVariationOptionIDs = [];

        $(document).on('click', '.remove_variation', function () {
            removedVariationIDs.push($(this).data('id'));
            $('#removedVariationIDs').val(removedVariationIDs.join(','));
        });
        $(document).on('click', '.remove_variation_option', function () {
            removedVariationOptionIDs.push($(this).data('id'));
            $('#removedVariationOptionIDs').val(removedVariationOptionIDs.join(','));
        });


        function validateImageSize(inputSelector, imageType = "Image", maxSizeMB = 2) {
            let fileInput = $(inputSelector)[0];
            if (fileInput && fileInput.files.length > 0) {
                let fileSize = fileInput.files[0].size;
                if (fileSize > maxSizeMB * 1024 * 1024) {
                    toastr.error(`${imageType} size should not exceed ${maxSizeMB}MB`, {
                        CloseButton: true,
                        ProgressBar: true
                    });
                    return false;
                }
            }
            return true;
        }

        $('#product_form').on('submit', function () {
            if (!validateImageSize('#image-input', "Food image") || !validateImageSize('#image-input2', "SEO image")) {
                return;
            }
            var formData = new FormData(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.post({
                url: '<?php echo e(route('admin.food.update', [$product['id']])); ?>',
                data: $('#product_form').serialize(),
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (data) {
                    $('#loading').hide();
                    if (data.errors) {
                        for (var i = 0; i < data.errors.length; i++) {
                            toastr.error(data.errors[i].message, {
                                CloseButton: true,
                                ProgressBar: true
                            });
                        }
                    } else {
                        toastr.success('<?php echo e(translate('product_updated_successfully!')); ?>', {
                            CloseButton: true,
                            ProgressBar: true
                        });
                        // location.reload(true);
                        setTimeout(function () {
                            location.href =
                                '<?php echo e(\Request::server('HTTP_REFERER') ?? route('admin.food.list')); ?>';
                        }, 2000);
                    }
                }
            });
        });


        $('#reset_btn').click(function () {
            location.reload(true);
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azentech/public_html/foodapp/resources/views/admin-views/product/edit.blade.php ENDPATH**/ ?>