<?php $__env->startSection('title',translate('FCM Settings')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-header-title">
                <span class="page-header-icon">
                    <img src="<?php echo e(dynamicAsset('public/assets/admin/img/firebase.png')); ?>" class="w--26" alt="">
                </span>
                <span><?php echo e(translate('messages.firebase_push_notification_setup')); ?>

                </span>
            </h1>
        </div>
        <!-- End Page Header -->
        <div class="card">
            <div class="card-header card-header-shadow pb-0">
                <div class="d-flex flex-wrap justify-content-between w-100 row-gap-1">
                    <ul class="nav nav-tabs nav--tabs border-0 gap-2">
                        <li class="nav-item mr-2 mr-md-4">
                            <a href="<?php echo e(route('admin.business-settings.fcm-index')); ?>" class="nav-link pb-2 px-0 pb-sm-3 " data-slide="1">
                                <img src="<?php echo e(dynamicAsset('/public/assets/admin/img/notify.png')); ?>" alt="">
                                <span><?php echo e(translate('Push Notification')); ?></span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.business-settings.fcm-config')); ?>" class="nav-link pb-2 px-0 pb-sm-3 active" data-slide="2">
                                <img src="<?php echo e(dynamicAsset('/public/assets/admin/img/firebase2.png')); ?>" alt="">
                                <span><?php echo e(translate('Firebase Configuration')); ?></span>
                            </a>
                        </li>
                    </ul>
                    <div class="py-1">
                            <div class="item text--primary-2 d-flex flex-wrap align-items-center" type="button" data-toggle="modal" data-target="#firebase-modal">
                                <strong class="mr-2"><?php echo e(translate('Where to get this information')); ?></strong>
                                <div class="blinkings">
                                    <i class="tio-info text-gray1 fs-16"></i>
                                </div>
                            </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <form action="<?php echo e(env('APP_MODE')!='demo'?route('admin.business-settings.update-fcm'):'javascript:'); ?>" method="post"
                        enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php ($serviceFileContent = \App\CentralLogics\Helpers::get_business_settings('push_notification_service_file_content')); ?>
                    <div class="form-group">
                        <label class="input-label"><?php echo e(translate('service_file_content')); ?>

                            <i class="tio-info cursor-pointer" data-toggle="tooltip" data-placement="top"
                               title="<?php echo e(translate('select and copy all the service file content and add here')); ?>">
                            </i>
                        </label>
                        <textarea name="push_notification_service_file_content" class="form-control" rows="15"
                                  required><?php echo e(env('APP_MODE')!='demo'?($serviceFileContent?json_encode($serviceFileContent):''):''); ?></textarea>
                    </div>

                    <div class="form-group">







                    <div class="form-group">
                        <label class="input-label" ><?php echo e(translate('messages.api_key')); ?></label>
                        <div class="d-flex">
                            <input type="text" value="<?php echo e(isset($fcm_credentials['apiKey'])?$fcm_credentials['apiKey']:''); ?>"
                                name="apiKey" class="form-control" placeholder="<?php echo e(translate('Ex : Api key')); ?>">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-4 col-sm-6">
                            <?php ($project_id=\App\Models\BusinessSetting::where('key','fcm_project_id')->first()); ?>
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('FCM Project ID')); ?></label>
                                <div class="d-flex">
                                    <input type="text" value="<?php echo e($project_id->value??''); ?>"
                                        name="projectId" class="form-control" placeholder="<?php echo e(translate('Ex: my-awesome-app-12345')); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6">
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('messages.auth_domain')); ?></label>
                                <div class="d-flex">
                                    <input type="text" value="<?php echo e(isset($fcm_credentials['authDomain'])?$fcm_credentials['authDomain']:''); ?>"
                                        name="authDomain" class="form-control" placeholder="<?php echo e(translate('Ex: my-awesome-app.firebaseapp.com')); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6">
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('messages.storage_bucket')); ?></label>
                                <div class="d-flex">
                                    <input type="text" value="<?php echo e(isset($fcm_credentials['storageBucket'])?$fcm_credentials['storageBucket']:''); ?>"
                                        name="storageBucket" class="form-control" placeholder="<?php echo e(translate('Ex: my-awesome-app.appspot.com')); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6">
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('messages.messaging_sender_id')); ?></label>
                                <div class="d-flex">
                                    <input type="text" value="<?php echo e(isset($fcm_credentials['messagingSenderId'])?$fcm_credentials['messagingSenderId']:''); ?>"
                                        name="messagingSenderId" class="form-control" placeholder="<?php echo e(translate('Ex: 1234567890')); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6">
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('messages.app_id')); ?></label>
                                <div class="d-flex">
                                    <input type="text" value="<?php echo e(isset($fcm_credentials['appId'])?$fcm_credentials['appId']:''); ?>"
                                        name="appId" class="form-control" placeholder="<?php echo e(translate('Ex: 9876543210')); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6">
                            <div class="form-group">
                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('messages.measurement_id')); ?></label>
                                <div class="d-flex">
                                    <input type="text" value="<?php echo e(isset($fcm_credentials['measurementId'])?$fcm_credentials['measurementId']:''); ?>"
                                        name="measurementId" class="form-control" placeholder="<?php echo e(translate('Ex: F-12345678')); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="text-right">
                        <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>" class="btn btn--primary call-demo"><?php echo e(translate('messages.submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>



        <!-- Firebase Modal -->
        <div class="modal fade" id="firebase-modal">
            <div class="modal-dialog status-warning-modal">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true" class="tio-clear"></span>
                        </button>
                    </div>
                    <div class="modal-body pb-5 pt-0">
                        <div class="max-349 mx-auto mb-20">
                            <div class="text-center">
                                <img src="<?php echo e(dynamicAsset('/public/assets/admin/img/firebase/slide-4.png')); ?>" alt="" class="mb-20">
                                <h5 class="modal-title"><?php echo e(translate('Please_Visit_the_Docs_to_Set_FCM_on_Mobile_Apps')); ?></h5>
                            </div>
                            <div class="text-center">
                                <p>
                                    <?php echo e(translate('Please_check_the_documentation_below_for_detailed_instructions_on_setting_up_your_mobile_app_to_receive_Firebase_Cloud_Messaging_(FCM)_notifications.')); ?>

                                </p>
                                <a href="https://docs.6amtech.com/docs-stack-food/mobile-apps/mandatory-setup/#setup-firebase-for-push-notification" target="_blank" ><?php echo e(translate('Click Here')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
<script src="<?php echo e(dynamicAsset('public/assets/admin/js/view-pages/business-settings-fcm.js')); ?>"></script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/azentech/public_html/foodapp/resources/views/admin-views/business-settings/fcm-config.blade.php ENDPATH**/ ?>