<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class APIGuestMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if ($request->headers->has('X-Auth-Token')) {
            $token = $request->header('X-Auth-Token');
            $request->headers->set('Authorization', $token);
        }
        
        
        if($request->header('Authorization') && $request->header('Authorization') !== 'Bearer null' && app('auth')->guard('api')) {
            $request->merge(['user'=>auth('api')->user()]);
            return $next($request);
        }
        elseif($request->guest_id) {
            return $next($request);
        }
        return response()->json(['errors' => 'Unauthorized'], 401);
    }
}
